module.exports = function(sequelize, DataTypes) {
    return sequelize.define('UserNote', {
            id: { type: DataTypes.INTEGER, primaryKey: true , autoIncrement: true },
            page_id: { type: DataTypes.INTEGER, allowNull: true },
            note_timestamp: { type: DataTypes.DATE, allowNull: false, defaultValue: 0 },
            deleted: { type: DataTypes.BOOLEAN, allowNull: false, defaultValue: false },
            user_id: { type: DataTypes.INTEGER, allowNull: false },
            note_id: { type: DataTypes.INTEGER, allowNull: false },
            task_in_book_id: { type: DataTypes.STRING(20), allowNull: true},
            book_id: { type: DataTypes.INTEGER, allowNull: false }
        },
    {
        timestamps: false,
        underscored: true,
        freezeTableName: true,
        tableName: 'usernotes'
    });
}